/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.challenge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.challenge.ChallengeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.server.MinecraftServer;

public class ChallengeSettings {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File CONFIG_FILE;
    private static Map<String, Boolean> enabledChallenges;
    private static Map<String, Map<String, Object>> challengeOptions;
    private static boolean isServerSide;
    private static MinecraftServer currentServer;

    public static void setServer(MinecraftServer server) {
        currentServer = server;
        isServerSide = server != null;
        CONFIG_FILE = isServerSide ? server.method_3831().resolve("config").resolve("challenges6t4-server.json").toFile() : FabricLoader.getInstance().getConfigDir().resolve("challenges6t4.json").toFile();
    }

    public static boolean isServerSide() {
        return isServerSide;
    }

    public static void loadSettings() {
        if (CONFIG_FILE == null) {
            CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("challenges6t4.json").toFile();
        }
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                Type type = new TypeToken<Map<String, Object>>(){}.getType();
                Map loaded = (Map)GSON.fromJson((Reader)reader, type);
                if (loaded != null) {
                    if (loaded.containsKey("enabled")) {
                        enabledChallenges = (Map)loaded.get("enabled");
                        for (Challenge challenge : ChallengeRegistry.getAllChallenges()) {
                            Boolean enabled = enabledChallenges.get(challenge.getId());
                            if (enabled == null) continue;
                            challenge.setEnabled(enabled);
                        }
                    }
                    if (loaded.containsKey("options")) {
                        challengeOptions = (Map)loaded.get("options");
                    }
                }
            }
            catch (IOException | ClassCastException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveSettings() {
        if (CONFIG_FILE == null) {
            return;
        }
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                enabledChallenges.clear();
                for (Challenge challenge : ChallengeRegistry.getAllChallenges()) {
                    enabledChallenges.put(challenge.getId(), challenge.isEnabled());
                }
                HashMap<String, Map<String, Object>> settings = new HashMap<String, Map<String, Object>>();
                settings.put("enabled", enabledChallenges);
                settings.put("options", challengeOptions);
                GSON.toJson(settings, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isEnabled(String challengeId) {
        return enabledChallenges.getOrDefault(challengeId, false);
    }

    public static void setEnabled(String challengeId, boolean enabled) {
        enabledChallenges.put(challengeId, enabled);
        ChallengeSettings.saveSettings();
    }

    public static boolean hasOption(String challengeId, String optionKey) {
        Map<String, Object> options = challengeOptions.get(challengeId);
        return options != null && options.containsKey(optionKey);
    }

    public static int getIntOption(String challengeId, String optionKey, int defaultValue) {
        Object value;
        Map<String, Object> options = challengeOptions.get(challengeId);
        if (options != null && options.containsKey(optionKey) && (value = options.get(optionKey)) instanceof Number) {
            return ((Number)value).intValue();
        }
        return defaultValue;
    }

    public static void setIntOption(String challengeId, String optionKey, int value) {
        Map options = challengeOptions.computeIfAbsent(challengeId, k -> new HashMap());
        options.put(optionKey, value);
        ChallengeSettings.saveSettings();
    }

    public static boolean getBooleanOption(String challengeId, String optionKey, boolean defaultValue) {
        Object value;
        Map<String, Object> options = challengeOptions.get(challengeId);
        if (options != null && options.containsKey(optionKey) && (value = options.get(optionKey)) instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public static void setBooleanOption(String challengeId, String optionKey, boolean value) {
        Map options = challengeOptions.computeIfAbsent(challengeId, k -> new HashMap());
        options.put(optionKey, value);
        ChallengeSettings.saveSettings();
    }

    public static void setLongOption(String challengeId, String key, long value) {
        Map options = challengeOptions.computeIfAbsent(challengeId, k -> new HashMap());
        options.put(key, value);
        ChallengeSettings.saveSettings();
    }

    public static long getLongOption(String challengeId, String key, long defaultValue) {
        Object value;
        Map<String, Object> options = challengeOptions.get(challengeId);
        if (options != null && options.containsKey(key) && (value = options.get(key)) instanceof Number) {
            return ((Number)value).longValue();
        }
        return defaultValue;
    }

    public static void setFloatOption(String challengeId, String optionKey, float value) {
        Map options = challengeOptions.computeIfAbsent(challengeId, k -> new HashMap());
        options.put(optionKey, Float.valueOf(value));
        ChallengeSettings.saveSettings();
    }

    public static float getFloatOption(String challengeId, String optionKey, float defaultValue) {
        Object value;
        Map<String, Object> options = challengeOptions.get(challengeId);
        if (options != null && options.containsKey(optionKey) && (value = options.get(optionKey)) instanceof Number) {
            return ((Number)value).floatValue();
        }
        return defaultValue;
    }

    public static String getStringOption(String challengeId, String optionKey, String defaultValue) {
        Object value;
        Map<String, Object> options = challengeOptions.get(challengeId);
        if (options != null && options.containsKey(optionKey) && (value = options.get(optionKey)) instanceof String) {
            return (String)value;
        }
        return defaultValue;
    }

    public static void setStringOption(String challengeId, String optionKey, String value) {
        Map options = challengeOptions.computeIfAbsent(challengeId, k -> new HashMap());
        options.put(optionKey, value);
        ChallengeSettings.saveSettings();
    }

    public static Map<String, Object> getChallengeOptions(String challengeId) {
        return challengeOptions.getOrDefault(challengeId, new HashMap());
    }

    static {
        enabledChallenges = new HashMap<String, Boolean>();
        challengeOptions = new HashMap<String, Map<String, Object>>();
        isServerSide = false;
        currentServer = null;
    }
}

